/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.types;

import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.blocks.types.WoodType;
import com.ldtteam.structurize.items.ModItemGroups;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;

public enum ShingleFaceType implements IBlockList<BlockShingle>
{
    CLAY("clay", "Clay", (IItemProvider)Items.field_151118_aC, DyeColor.values()),
    SLATE("slate", "Slate", (IItemProvider)Blocks.field_150347_e, DyeColor.BLUE, DyeColor.GREEN, DyeColor.PURPLE),
    MOSS_SLATE("moss_slate", "Moss Slate", (IItemProvider)Blocks.field_150341_Y, new DyeColor[0]),
    THATCHED("thatched", "Thatched", (IItemProvider)Items.field_151015_O, new DyeColor[0]),
    BLACKSTONE("blackstone", "Blackstone", (IItemProvider)Blocks.field_235406_np_, new DyeColor[0]),
    GILDED_BLACKSTONE("gilded_blackstone", "Gilded Blackstone", (IItemProvider)Blocks.field_235387_nA_, new DyeColor[0]);

    private final Map<WoodType, List<RegistryObject<BlockShingle>>> blocks = new LinkedHashMap<WoodType, List<RegistryObject<BlockShingle>>>();
    private final Map<WoodType, ITag.INamedTag<Block>> blockTags = new LinkedHashMap<WoodType, ITag.INamedTag<Block>>();
    final String group;
    final String langName;
    final IItemProvider ingredient;
    final DyeColor[] colors;

    private ShingleFaceType(String group, String langGroup, IItemProvider material, DyeColor ... colors) {
        this.group = group;
        this.langName = langGroup;
        this.ingredient = material;
        this.colors = colors;
        for (int i = -1; i < colors.length; ++i) {
            DyeColor color = i < 0 ? null : colors[i];
            String prefix = (i < 0 ? "" : color.func_176610_l() + "_") + group;
            for (WoodType wood : WoodType.values()) {
                this.blocks.putIfAbsent(wood, new LinkedList());
                this.blocks.get((Object)wood).add(ModBlocks.register(String.format("%s_%s_shingle", prefix, wood.func_176610_l()), () -> new BlockShingle(() -> ((Block)Blocks.field_196662_n).func_176223_P(), wood, this, color), ModItemGroups.SHINGLES));
            }
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getLangName() {
        return this.langName;
    }

    public IItemProvider getMaterial() {
        return this.ingredient;
    }

    public DyeColor[] getColors() {
        return this.colors;
    }

    @Override
    public List<RegistryObject<BlockShingle>> getRegisteredBlocks() {
        return this.blocks.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private ModelFile makeBlockModel(BlockModelProvider models, BlockShingle shingle, String shape) {
        String location = shingle.getTypeString() + "_shingle";
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(String.format("block/shingle/%s/%s/%s", shape, shingle.getWoodType().func_176610_l(), location), models.modLoc("block/shingle/shingle_" + shape))).texture("1", "blocks/shingle/" + location + "_1")).texture("2", "blocks/shingle/" + location + "_2")).texture("3", "blocks/shingle/" + location + "_3")).texture("plank", shingle.getWoodType() == WoodType.CACTUS ? "blocks/cactus/blockcactusplank" : "minecraft:block/" + shingle.getWoodType().getMaterial().getRegistryName().func_110623_a())).texture("particle", "blocks/shingle/" + location + "_1");
    }

    @Override
    public void generateBlockStates(ModBlockStateProvider states) {
        this.getRegisteredBlocks().forEach(block -> {
            BlockShingle shingle = (BlockShingle)block.get();
            states.stairsBlockUnlockUV(shingle, this.makeBlockModel(states.models(), shingle, "straight"), this.makeBlockModel(states.models(), shingle, "concave"), this.makeBlockModel(states.models(), shingle, "convex"));
        });
    }

    @Override
    public void generateItemModels(ModItemModelProvider models) {
        this.getBlocks().forEach(block -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)models.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(models.modLoc(String.format("block/shingle/straight/%s/%s_shingle", block.getWoodType().func_176610_l(), block.getTypeString()))));
        });
    }

    @Override
    public void generateRecipes(ModRecipeProvider provider) {
        this.getRegisteredBlocks().forEach(block -> provider.add(consumer -> {
            DyeColor color = ((BlockShingle)block.get()).getColor();
            if (color == null) {
                new ShapedRecipeBuilder((IItemProvider)block.get(), 8).func_200472_a("I  ").func_200472_a("SI ").func_200472_a("PSI").func_200462_a(Character.valueOf('I'), ((BlockShingle)block.get()).getFaceType().getMaterial()).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('P'), (IItemProvider)((BlockShingle)block.get()).getWoodType().getMaterial()).func_200465_a("has_" + ((BlockShingle)block.get()).getRegistryName().func_110623_a(), ModRecipeProvider.getDefaultCriterion((IItemProvider)block.get())).func_200464_a(consumer);
            } else {
                new ShapelessRecipeBuilder((IItemProvider)block.get(), 8).func_200491_b((IItemProvider)this.blocks.get((Object)((BlockShingle)block.get()).getWoodType()).get(0).get(), 8).func_200487_b((IItemProvider)DyeItem.func_195961_a((DyeColor)color)).func_200483_a("has_" + ((BlockShingle)block.get()).getRegistryName().func_110623_a(), ModRecipeProvider.getDefaultCriterion((IItemProvider)block.get())).func_200482_a(consumer);
            }
        }));
    }

    @Override
    public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
        this.getRegisteredBlocks().forEach(block -> {
            if (!this.blockTags.containsKey((Object)((BlockShingle)block.get()).getWoodType())) {
                this.blockTags.put(((BlockShingle)block.get()).getWoodType(), blocks.createTag("shingles/" + this.getGroup() + "/" + ((BlockShingle)block.get()).getWoodType().func_176610_l()));
            }
            blocks.buildTag(this.blockTags.get((Object)((BlockShingle)block.get()).getWoodType())).func_240532_a_((Object)block.get());
        });
        ITag.INamedTag<Block> groupTag = blocks.createTag("shingles/" + this.getGroup());
        this.blockTags.values().forEach(arg_0 -> blocks.buildTag(groupTag).func_240531_a_(arg_0));
        this.blockTags.values().forEach(items::copy);
        items.copy(groupTag);
    }
}

